% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_update_expiration_for_hit}
\alias{mturk_update_expiration_for_hit}
\title{The UpdateExpirationForHIT operation allows you update the expiration
time of a HIT}
\usage{
mturk_update_expiration_for_hit(HITId, ExpireAt)
}
\arguments{
\item{HITId}{[required] The HIT to update.}

\item{ExpireAt}{[required] The date and time at which you want the HIT to expire}
}
\description{
The \code{UpdateExpirationForHIT} operation allows you update the expiration
time of a HIT. If you update it to a time in the past, the HIT will be
immediately expired.
}
\section{Request syntax}{
\preformatted{svc$update_expiration_for_hit(
  HITId = "string",
  ExpireAt = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
