% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_describe_reserved_elasticsearch_instances}
\alias{elasticsearchservice_describe_reserved_elasticsearch_instances}
\title{Returns information about reserved Elasticsearch instances for this
account}
\usage{
elasticsearchservice_describe_reserved_elasticsearch_instances(
  ReservedElasticsearchInstanceId, MaxResults, NextToken)
}
\arguments{
\item{ReservedElasticsearchInstanceId}{The reserved instance identifier filter value. Use this parameter to
show only the reservation that matches the specified reserved
Elasticsearch instance ID.}

\item{MaxResults}{Set this value to limit the number of results returned. If not
specified, defaults to 100.}

\item{NextToken}{NextToken should be sent in case if earlier API call produced result
containing NextToken. It is used for pagination.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  ReservedElasticsearchInstances = list(
    list(
      ReservationName = "string",
      ReservedElasticsearchInstanceId = "string",
      ReservedElasticsearchInstanceOfferingId = "string",
      ElasticsearchInstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      Duration = 123,
      FixedPrice = 123.0,
      UsagePrice = 123.0,
      CurrencyCode = "string",
      ElasticsearchInstanceCount = 123,
      State = "string",
      PaymentOption = "ALL_UPFRONT"|"PARTIAL_UPFRONT"|"NO_UPFRONT",
      RecurringCharges = list(
        list(
          RecurringChargeAmount = 123.0,
          RecurringChargeFrequency = "string"
        )
      )
    )
  )
)
}
}
\description{
Returns information about reserved Elasticsearch instances for this
account.
}
\section{Request syntax}{
\preformatted{svc$describe_reserved_elasticsearch_instances(
  ReservedElasticsearchInstanceId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
