% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_delete_schema_versions}
\alias{glue_delete_schema_versions}
\title{Remove versions from the specified schema}
\usage{
glue_delete_schema_versions(SchemaId, Versions)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure that may contain the schema name and Amazon
Resource Name (ARN).}

\item{Versions}{[required] A version range may be supplied which may be of the format:
\itemize{
\item a single version number, 5
\item a range, 5-8 : deletes versions 5, 6, 7, 8
}}
}
\value{
A list with the following syntax:\preformatted{list(
  SchemaVersionErrors = list(
    list(
      VersionNumber = 123,
      ErrorDetails = list(
        ErrorCode = "string",
        ErrorMessage = "string"
      )
    )
  )
)
}
}
\description{
Remove versions from the specified schema. A version number or range may
be supplied. If the compatibility mode forbids deleting of a version
that is necessary, such as BACKWARDS_FULL, an error is returned.
Calling the \code{GetSchemaVersions} API after this call will list the status
of the deleted versions.

When the range of version numbers contain check pointed version, the API
will return a 409 conflict and will not proceed with the deletion. You
have to remove the checkpoint first using the \code{DeleteSchemaCheckpoint}
API before using this API.

You cannot use the
\code{\link[=glue_delete_schema_versions]{delete_schema_versions}} API to delete
the first schema version in the schema set. The first schema version can
only be deleted by the \code{\link[=glue_delete_schema]{delete_schema}} API. This
operation will also delete the attached \code{SchemaVersionMetadata} under
the schema versions. Hard deletes will be enforced on the database.

If the compatibility mode forbids deleting of a version that is
necessary, such as BACKWARDS_FULL, an error is returned.
}
\section{Request syntax}{
\preformatted{svc$delete_schema_versions(
  SchemaId = list(
    SchemaArn = "string",
    SchemaName = "string",
    RegistryName = "string"
  ),
  Versions = "string"
)
}
}

\keyword{internal}
