% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_delete_studio_session_mapping}
\alias{emr_delete_studio_session_mapping}
\title{The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change}
\usage{
emr_delete_studio_session_mapping(StudioId, IdentityId, IdentityName,
  IdentityType)
}
\arguments{
\item{StudioId}{[required] The ID of the Amazon EMR Studio.}

\item{IdentityId}{The globally unique identifier (GUID) of the user or group to remove
from the Amazon EMR Studio. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserId}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId}{GroupId}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityName}{The name of the user name or group to remove from the Studio. For more
information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserName}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName}{DisplayName}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityType}{[required] Specifies whether the identity to delete from the Studio is a user or a
group.}
}
\value{
An empty list.
}
\description{
The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change.

Removes a user or group from an Amazon EMR Studio.
}
\section{Request syntax}{
\preformatted{svc$delete_studio_session_mapping(
  StudioId = "string",
  IdentityId = "string",
  IdentityName = "string",
  IdentityType = "USER"|"GROUP"
)
}
}

\keyword{internal}
