% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_delete_qualification_type}
\alias{mturk_delete_qualification_type}
\title{The DeleteQualificationType deletes a Qualification type and deletes any
HIT types that are associated with the Qualification type}
\usage{
mturk_delete_qualification_type(QualificationTypeId)
}
\arguments{
\item{QualificationTypeId}{[required] The ID of the QualificationType to dispose.}
}
\description{
The \code{DeleteQualificationType} deletes a Qualification type and deletes
any HIT types that are associated with the Qualification type.

This operation does not revoke Qualifications already assigned to
Workers because the Qualifications might be needed for active HITs. If
there are any pending requests for the Qualification type, Amazon
Mechanical Turk rejects those requests. After you delete a Qualification
type, you can no longer use it to create HITs or HIT types.

DeleteQualificationType must wait for all the HITs that use the deleted
Qualification type to be deleted before completing. It may take up to 48
hours before DeleteQualificationType completes and the unique name of
the Qualification type is available for reuse with
CreateQualificationType.
}
\section{Request syntax}{
\preformatted{svc$delete_qualification_type(
  QualificationTypeId = "string"
)
}
}

\keyword{internal}
