% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_tag_resource}
\alias{glue_tag_resource}
\title{Adds tags to a resource}
\usage{
glue_tag_resource(ResourceArn, TagsToAdd)
}
\arguments{
\item{ResourceArn}{[required] The ARN of the AWS Glue resource to which to add the tags. For more
information about AWS Glue resource ARNs, see the \href{http://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id}{AWS Glue ARN string pattern}.}

\item{TagsToAdd}{[required] Tags to add to this resource.}
}
\description{
Adds tags to a resource. A tag is a label you can assign to an AWS
resource. In AWS Glue, you can tag only certain resources. For
information about what resources you can tag, see \href{http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html}{AWS Tags in AWS Glue}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  TagsToAdd = list(
    "string"
  )
)
}
}

\keyword{internal}
