% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_table}
\alias{glue_get_table}
\title{Retrieves the Table definition in a Data Catalog for a specified table}
\usage{
glue_get_table(CatalogId, DatabaseName, Name)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the table resides. If none is supplied,
the AWS account ID is used by default.}

\item{DatabaseName}{[required] The name of the database in the catalog in which the table resides. For
Hive compatibility, this name is entirely lowercase.}

\item{Name}{[required] The name of the table for which to retrieve the definition. For Hive
compatibility, this name is entirely lowercase.}
}
\description{
Retrieves the \code{Table} definition in a Data Catalog for a specified
table.
}
\section{Request syntax}{
\preformatted{svc$get_table(
  CatalogId = "string",
  DatabaseName = "string",
  Name = "string"
)
}
}

\keyword{internal}
