% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsmooth.R
\name{plotsmooth}
\alias{plotsmooth}
\title{Plot loess smoothed curves}
\usage{
plotsmooth(rspecdata, minsmooth = 0.05, maxsmooth = 0.2, curves = 5,
  specnum = 0, ask = TRUE)
}
\arguments{
\item{rspecdata}{(required) a data frame, possibly of class \code{rspec}, which
contains a column containing a wavelength range , named 'wl', and spectra data in
remaining columns.}

\item{minsmooth}{the minimum f value of the loess function to visualize (defaults to \code{0.05}).}

\item{maxsmooth}{the maximum f value of the loess function to visualize (defaults to \code{0.20}).}

\item{curves}{the number of curves to display on the same plot (defaults to \code{5}).}

\item{specnum}{the number of spectral curves, from the data frame, to visualize (defaults to \code{ALL}).}

\item{ask}{logical. if \code{TRUE}, asks for user input before changing plot pages}
}
\value{
Series of plot with curves processed with varying level of loess smoothing
}
\description{
Plots curves with various levels of loess smoothing to help determine what
loess parameters are best for the data.
}
\examples{
\dontrun{
data(sicalis)
plotsmooth(sicalis,0.05,0.1,7,6)
}

}
\author{
Pierre-Paul Bitton \email{bittonp@uwindsor.ca}
}
