% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diplot.R
\name{diplot}
\alias{diplot}
\title{Plot a dichromat segment}
\usage{
diplot(didata, labels = TRUE, achro = TRUE, achrocol = "grey",
  achrosize = 0.8, lab.cex = 1, out.lwd = 1, out.lcol = "black",
  out.lty = 1, margins = c(1, 1, 2, 2), square = TRUE, ...)
}
\arguments{
\item{didata}{(required) a data frame, possibly a result from the \code{dispace} 
function, containing values for the 'x' coordinates as a column (labeled as such).}

\item{labels}{plot verticy labels? Defaults to \code{TRUE}.}

\item{achro}{should a point be plotted at the origin (defaults to \code{TRUE})?}

\item{achrocol}{color of the point at the origin \code{achro = TRUE} (defaults to \code{'grey'}).}

\item{achrosize}{size of the point at the origin when \code{achro = TRUE} (defaults to \code{0.8}).}

\item{lab.cex}{character expansion factor for category labels when \code{labels = TRUE}).}

\item{out.lwd, out.lcol, out.lty}{graphical parameters for the segment.}

\item{margins}{margins for the plot.}

\item{square}{logical. Should the aspect ratio of the plot be held to 1:1? 
(defaults to \code{TRUE})}

\item{...}{additional graphical options. See \code{\link{par}}.}
}
\description{
Produces a dichromat segment plot.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'canis')
di.flowers <- colspace(vis.flowers, space = 'di')
plot(di.flowers)
}

}
\references{
Kelber A, Vorobyev M, Osorio D. (2003). Animal colour vision
   - behavioural tests and physiological concepts. Biological Reviews, 78,
   81 - 118.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
