% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternpie.R
\name{patternpie}
\alias{patternpie}
\title{Plot a piechart using patterns and colors to fill the slices.}
\usage{
patternpie(group, pct, label, label.size = 4, label.color = "black",
  label.distance = 1.2, pattern.type, pattern.color = rep("black",
  length(group)), pattern.line.size = 1, background.color = rep("white",
  length(group)), frame.color = "black", frame.size = 1, pixel)
}
\arguments{
\item{group}{a vector of strings, containing the names of each slice.}

\item{pct}{a vector of non-negative numbers, containing percentages of each group.
The numbers must sum up to 100.}

\item{label}{a vector of strings, giving the names for the slices shown in the pie chart}

\item{label.size}{the font size of labels shown in the pie chart}

\item{label.color}{the color of labels shown in the pie chart}

\item{label.distance}{the distance of labels from the border of the pie chart}

\item{pattern.type}{a vector of patterns to be filled in the slices. 
There are 13 pattern types: 'blank', 'bricks', 'circles1','circles2', 
'crosshatch','dots', 'grid','hlines','nelines', 'nwlines', 'shells', 'vlines', 'waves'.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{pattern.line.size}{a numeric value, the line size for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the slices.}

\item{frame.color}{the color for the borders of slices.}

\item{frame.size}{a numeric value, the line size for the borders of slices.}

\item{pixel}{a numeric value, the pixel resolution of pie chart.}
}
\value{
A ggplot object.
}
\description{
The \code{patternpie} function is a tool for creating versatile pie charts.
It has the capacity to fill slices with patterns and colors. Users can create 
either black and white pattern pie charts which are useful for scientific 
publications, or colorful pie charts with or without patterns which are 
good for presentations.
}
\details{
\code{patternpie} function offers flexible ways in doing pie charts.
}
\examples{
##Piecharts in black and white
#A simple example to start with. 
library(patternplot)
group<-c('A', 'B')
pct<-c(25, 75)
label<-paste(group, ' ',pct,'\%', sep='' )
pattern.type<-c('hlines', 'grid')
patternpie(group=group,pct=pct,label =label, pattern.type=pattern.type,
           pixel=0.5, pattern.line.size=0.3, frame.size=1.5)
}
\author{
Chunqiao Luo (cluo@uams.edu)
}
\seealso{
Function \code{imagepie}
}

