% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectedNNsInfo.R
\name{projectedNNsInfo}
\alias{projectedNNsInfo}
\title{Projected Nearest Neighbors Information}
\usage{
projectedNNsInfo(My, Dy, SMy, PSMy, timesX, i, h)
}
\arguments{
\item{My}{Matrix of coordinates in the original space.}

\item{Dy}{Distance matrix, representing distances between elements in My.}

\item{SMy}{Matrix of signatures, capturing essential patterns in the data.}

\item{PSMy}{Matrix of patterns, representing characteristic configurations of the data.}

\item{timesX}{Index at which the projection starts.}

\item{i}{Index of the specific element for which information is being extracted.}

\item{h}{Horizon over which the projection is considered.}
}
\value{
A list containing indices of the element, the projected times, distances, weights derived from these distances, signatures, patterns, and the coordinates of the nearest neighbors.
}
\description{
Extracts and returns information about the projected nearest neighbors in a time series context, specifically useful for understanding interactions in dynamic complex systems.
}
\examples{
set.seed(123)
E <- 3
tau <- 1
Mx <- matrix(rnorm(200), nrow = 20)
My <- matrix(rnorm(200), nrow = 20)
Dx <- distanceMatrix(Mx, "minkowski")
Dy <- distanceMatrix(My, "minkowski")
SMx <- signatureSpace(Mx, E)
SMy <- signatureSpace(My, E)
PSMx <- patternSpace(SMx, E)
PSMy <- patternSpace(SMy, E)
CCSPAN <- (E - 1) * tau
NNSPAN <- E + 1
i <- 15
h <- 2
NNx <- pastNNsInfo(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
timesX <- NNx$times
projNNy <- projectedNNsInfo(My, Dy, SMy, PSMy, timesX, i, h)
print(projNNy)
}
