% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.R
\name{decompose_path}
\alias{decompose_path}
\alias{get_extension}
\alias{recompose_path}
\alias{recompose_path.decomposed_path}
\alias{replace_extension}
\alias{strip_extension}
\title{Split a path into its components}
\usage{
decompose_path(x = dir())

get_extension(x = dir())

recompose_path(x, ...)

\method{recompose_path}{decomposed_path}(x, ...)

replace_extension(x = dir(), new_extension, include_dir = NA)

strip_extension(x = dir(), include_dir = NA)
}
\arguments{
\item{x}{A character vector of file paths. Defaults to files in the 
current directory.}

\item{...}{Not currently used.}

\item{new_extension}{A new extension to replace the existing ones.}

\item{include_dir}{Should the directory part of the path be included? If 
\code{NA}, the default, keep the directory from the input.  If \code{TRUE},
standardize the directory.  If \code{FALSE}, strip the directory.}
}
\value{
\code{decompose_path} returns a character matrix with three 
columns named \code{"dirname"}, \code{"filename"} and \code{"extension"}.
\code{strip_extension} returns a character vector of the filename, possibly 
with a directory (see \code{include_dir} argument).
\code{replace_extension} returns a character vector of the filename with a  
newextension, possibly with a directory (see \code{include_dir} argument).
\code{get_extension} returns a character vector of the third column.
\code{recompose_path} returns a character vector of paths.
}
\description{
\code{decompose_path} splits a path into the directory name, filename 
without extension, and extension. \code{strip_extension}, 
\code{get_extension} and \code{replace_extension} provide shortcuts to 
manipulate the file extension. \code{recompose_path} takes the result of 
\code{decompose_path} and returns complete paths.
}
\note{
Decomposing and then recomposing a path is usually equivalent to 
standardizing that path (though slower).  That is, usually
\code{recompose_path(decompose_path(x)) == standardize_path(x)}.
One exception to this is when the directory of x is a symbolic link to 
another directory.  In this case \code{decompose_path} will follow the
link but \code{standardize_path} won't.
}
\section{Warning}{

A few of the tests for this function don't pass under the CRAN Windows 
machine.  It is unclear exactly why this is happening, and the failing tests
have not been reproduced elsewhere.  If you have unexpected behaviour with
this function, please report it on the package issue tracker.
\url{https://github.com/richierocks/pathological/issues}
}
\examples{
x <- c(
  "somedir/foo.tgz",         # single extension
  "another dir\\\\bar.tar.gz", # double extension
  "baz",                     # no extension
  "quux. quuux.tbz2",        # single ext, dots in filename
  R.home(),                  # a dir
  "~",                       # another dir
  "~/quuuux.tar.xz",         # a file in a dir
  "",                        # empty 
  ".",                       # current dir
  "..",                      # parent dir
  NA_character_              # missing
)
(decomposed <- decompose_path(x))
get_extension(x)
strip_extension(x)
strip_extension(x, FALSE)
recompose_path(decomposed)
}
\seealso{
\code{\link[tools]{file_ext}}, a primitive version of 
\code{get_extension}
}

