% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{pathling_encode}
\alias{pathling_encode}
\title{Encode FHIR JSON or XML to a dataframe}
\usage{
pathling_encode(pc, df, resource_name, input_type = NULL, column = NULL)
}
\arguments{
\item{pc}{The Pathling context object.}

\item{df}{A Spark DataFrame containing the resources to encode.}

\item{resource_name}{The name of the FHIR resource to extract (e.g., "Condition", "Observation").}

\item{input_type}{The MIME type of input string encoding. Defaults to "application/fhir+json".}

\item{column}{The column in which the resources to encode are stored. If set to NULL, the input
DataFrame is assumed to have one column of type string.}
}
\value{
A Spark DataFrame containing the given type of resources encoded into Spark columns.
}
\description{
Takes a Spark DataFrame with string representations of FHIR resources in the given column and
encodes the resources of the given types as Spark DataFrame.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) withAutoprint(\{ # examplesIf}
pc <- pathling_connect()
json_resources_df <- pathling_spark(pc) \%>\%
  sparklyr::spark_read_text(path = system.file("extdata", "ndjson", "Condition.ndjson",
    package = "pathling"
  ))
pc \%>\% pathling_encode(json_resources_df, "Condition")
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
Other encoding functions: 
\code{\link{pathling_encode_bundle}()}
}
\concept{encoding functions}
