% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_processing.R
\name{input_processing}
\alias{input_processing}
\title{Process Input}
\usage{
input_processing(input, p_val_threshold, pin_path)
}
\arguments{
\item{input}{the input data that pathfindR uses. The input must be a data
  frame with three columns: \enumerate{
  \item Gene Symbol (HGNC Gene Symbol)
  \item Change value, e.g. log(fold change)
  \item adjusted p value associated with test, e.g. differential expression/methylation
}}

\item{p_val_threshold}{the adjusted-p value threshold to use when filtering
the input data frame}

\item{pin_path}{path to the Protein Interaction Network (PIN) file used in
the analysis}
}
\value{
This function first filters the input so that all p values are less
  than or equal to the threshold. Next, gene symbols that are not found in
  the PIN are identified. If aliases of these gene symbols are found in the
  PIN, the symbols are converted to the corresponding aliases. The
  resulting data frame containing the original gene symbols, the updated
  symbols, change values and p values is then returned.
}
\description{
Process Input
}
\examples{
\dontshow{
input_processing(RA_input[1,], 0.05, return_pin_path("KEGG"))
}
\dontrun{
input_processing(RA_input, 0.05, return_pin_path("KEGG"))
}
}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR workflow
}
