% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_pathfindR_output_clustered}
\alias{example_pathfindR_output_clustered}
\title{Example Output for the pathfindR Clustering Workflow - Rheumatoid Arthritis}
\format{
A data frame with 128 rows and 11 columns:
\describe{
\item{ID}{ID of the enriched term}
\item{Term_Description}{Description of the enriched term}
\item{Fold_Enrichment}{Fold enrichment value for the enriched term}
\item{occurrence}{the number of iterations that the given term was found to enriched over all iterations}
\item{support}{the median support (proportion of active subnetworks leading to enrichment within an iteration) over all iterations}s
\item{lowest_p}{the lowest adjusted-p value of the given term over all iterations}
\item{highest_p}{the highest adjusted-p value of the given term over all iterations}
\item{Up_regulated}{the up-regulated genes in the input involved in the given term, comma-separated}
\item{Down_regulated}{the down-regulated genes in the input involved in the given term, comma-separated}
\item{Cluster}{the cluster to which the enriched term is assigned}
\item{Status}{whether the enriched term is the "Representative" term in its cluster or only a "Member"}
}
}
\usage{
example_pathfindR_output_clustered
}
\description{
A dataset containing the results of pathfindR's clustering and
partitioning workflow performed on the rheumatoid arthritis
enrichment results \code{\link{example_pathfindR_output}}. The clustering and partitioning
function \code{\link[pathfindR]{cluster_enriched_terms}} was used with the default settings
(i.e. hierarchical clustering was performed and the agglomeration method
was "average").
\emph{Generated on Dec, 2022.}
}
\seealso{
\code{\link{example_pathfindR_input}}  for the RA differentially-expressed genes data frame
\code{\link{example_experiment_matrix}} for the RA differentially-expressed genes expression matrix
\code{\link[pathfindR]{run_pathfindR}} for details on the pathfindR enrichment analysis
\code{\link{example_pathfindR_output}} for the RA example pathfindR enrichment output
\code{\link[pathfindR]{cluster_enriched_terms}} for details on clustering methods
}
\keyword{datasets}
