% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_series.R
\name{location_series}
\alias{location_series}
\title{Extract a time series of bioclimatic variables for one or more locations.}
\usage{
location_series(
  x,
  time_bp = NULL,
  bio_variables,
  dataset,
  path_to_nc = NULL,
  nn_interpol = FALSE,
  buffer = FALSE,
  directions = 8
)
}
\arguments{
\item{x}{a data.frame with columns \code{longitude}, ranging
-180 to 180, and \code{latitude}, from -90 to 90 (and an optional \code{name}),
or a vector of cell numbers.}

\item{time_bp}{time slices in years before present (negative values represent
time before present, positive values time in the future). This parameter can
be a vector of times (the slices need
to exist in the dataset), a list with a min and max element setting the
range of values, or left to NULL to retrieve all time steps.
To check which slices are available, you can use
\code{\link[=get_time_steps]{get_time_steps()}}.}

\item{bio_variables}{vector of names of variables to be extracted.}

\item{dataset}{string defining the dataset to use. If set to "custom",
then a single nc file is used from "path_to_nc"}

\item{path_to_nc}{the path to the custom nc file containing the palaeoclimate
reconstructions. All the variables of interest need to be included in
this file.}

\item{nn_interpol}{boolean determining whether nearest neighbour
interpolation is used to estimate climate for cells that lack such
information (i.e. they are under water or ice). By default, interpolation is only
performed from the first ring of nearest neighbours; if climate is not
available, NA will be returned for that location. The number of neighbours
can be changed with the argument \code{directions}. \code{nn_interpol} defaults to FALSE
(this is DIFFERENT from \code{\link[=location_slice]{location_slice()}}.}

\item{buffer}{boolean determining whether the variable will be returned
as the mean of a buffer around the focal cell. If set to TRUE, it overrides
\code{nn_interpol} (which provides the same estimates as \code{buffer} but only for
locations that are in cells with an NA). The buffer size is determined
by the argument \code{directions}. \code{buffer} defaults to FALSE.}

\item{directions}{character or matrix to indicate the directions in which
cells are considered connected when using \code{nn_interpol} or \code{buffer}.
The following character values are allowed: "rook" or "4" for the
horizontal and vertical neighbours; "bishop" to get the diagonal neighbours;
"queen" or "8" to get the vertical, horizontal and diagonal neighbours;
or "16" for knight and one-cell queen move neighbours. If directions
is a matrix it should have odd dimensions and have logical (or 0, 1) values.}
}
\value{
a data.frame with the climatic variables of interest
}
\description{
This function extract a time series of local climate for
a set of locations. Note that this function does not apply any interpolation
(as opposed to \code{\link[=location_slice]{location_slice()}}). If you have a coastal location that just
falls into the water for the reconstructions, you will have to amend the coordinates
to put it more firmly on land.
}
