% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time_uncert_resolvers.R
\name{definitely.partial_time_logical}
\alias{definitely.partial_time_logical}
\title{Determine whether a partial_time logical matrix is definitely TRUE}
\usage{
\method{definitely}{partial_time_logical}(x, by = ncol(attr(x, "pttm_lgl")), ...)
}
\arguments{
\item{x}{a partial_time_logical matrix for coersion}

\item{by}{the resolution of assessment, a column or index}

\item{...}{additional arguments unused}
}
\value{
A logical vector indicating whether the partial time comparison is
possibly or definitely true provided any uncertainty represented in the
\code{partial_time} inputs.
}
\description{
Determine whether a partial_time logical matrix is definitely TRUE
}
\examples{

x <- as.parttime(c("", "2019", "2018-01-02"))
y <- as.parttime(c("2018", "2019-02", "2018-02"))

definitely(x != y)
definitely(x != y, by = "year")

}
