% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{fagerMcGowan}
\alias{fagerMcGowan}
\alias{fagerMcGowan,Partition,Partition-method}
\alias{fagerMcGowan,PairCoefficients,missing-method}
\title{Fager & McGowan Index}
\usage{
fagerMcGowan(p, q)

\S4method{fagerMcGowan}{Partition,Partition}(p, q)

\S4method{fagerMcGowan}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index of Fager and McGowan
\deqn{\frac{N_{11}}{\sqrt{N_{21}N_{12}}} - \frac{1}{2\sqrt{N_{21}}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(fagerMcGowan(new("Partition", c(0, 0, 0, 1, 1)), 
                              new("Partition", c(0, 0, 1, 1, 1))), 0.25))

}
\references{
\insertRef{Fager1963}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
