% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{folwkesMallowsIndex}
\alias{folwkesMallowsIndex}
\alias{folwkesMallowsIndex,Partition,Partition-method}
\alias{folwkesMallowsIndex,PairCoefficients,missing-method}
\title{Folwkes & Mallows Index}
\usage{
folwkesMallowsIndex(p, q)

\S4method{folwkesMallowsIndex}{Partition,Partition}(p, q)

\S4method{folwkesMallowsIndex}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index of Folwkes and Mallows
\deqn{\sqrt{\frac{N_{11}}{N_{21}} \frac{N_{11}}{N_{12}}}}
which is a combination of the two Wallace indices.
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(folwkesMallowsIndex(new("Partition", c(0, 0, 0, 1, 1)), 
                                     new("Partition", c(0, 0, 1, 1, 1))), 0.5))

}
\references{
\insertRef{Fowlkes1983}{partitionComparison}
}
\seealso{
\code{\link{wallaceI}} \code{\link{wallaceII}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
