% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{hamann}
\alias{hamann}
\alias{hamann,Partition,Partition-method}
\alias{hamann,PairCoefficients,missing-method}
\title{Hamann Coefficient}
\usage{
hamann(p, q)

\S4method{hamann}{Partition,Partition}(p, q)

\S4method{hamann}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Hamann coefficient
\deqn{\frac{(N_{11} + N_{00}) - (N_{10} + N_{01})}{N}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
hamann(new("Partition", c(0, 0, 0, 1, 1)), new("Partition", c(0, 0, 1, 1, 1))) == 0.2

}
\references{
\insertRef{Hamann1961}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
