% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{as_measure}
\alias{as_measure}
\title{Create a custom metric}
\usage{
as_measure(.f, ...)
}
\arguments{
\item{.f}{a function that returns either a numeric vector or a \code{data.frame}}

\item{...}{Extra arguments passed to \code{.f}.}
}
\value{
a function to use in \code{\link[=as_partitioner]{as_partitioner()}}
}
\description{
Metrics are functions that tell how much information would be
lost for a given reduction in the data. reduce.  \code{\link[=as_measure]{as_measure()}} is a
helper function to create new metrics to be used in \code{partitioner}s.
\code{partitioner}s can be created with \code{\link[=as_partitioner]{as_partitioner()}}.
}
\examples{

inter_item_reliability <- function(.data) {
   corr(.data) \%>\%
    colMeans(na.rm = TRUE) \%>\%
    mean()
}

measure_iir <- as_measure(inter_item_reliability)
measure_iir

}
\seealso{
Other metrics: 
\code{\link{measure_icc}()},
\code{\link{measure_min_icc}()},
\code{\link{measure_min_r2}()},
\code{\link{measure_std_mutualinfo}()},
\code{\link{measure_variance_explained}()}

Other metrics: 
\code{\link{measure_icc}()},
\code{\link{measure_min_icc}()},
\code{\link{measure_min_r2}()},
\code{\link{measure_std_mutualinfo}()},
\code{\link{measure_variance_explained}()}
}
\concept{metrics}
