% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioners.R
\name{as_partitioner}
\alias{as_partitioner}
\title{Create a partitioner}
\usage{
as_partitioner(direct, measure, reduce)
}
\arguments{
\item{direct}{a function that directs, possibly created by \code{\link[=as_director]{as_director()}}}

\item{measure}{a function that measures, possibly created by \code{\link[=as_measure]{as_measure()}}}

\item{reduce}{a function that reduces, possibly created by \code{\link[=as_reducer]{as_reducer()}}}
}
\value{
a \code{partitioner}
}
\description{
Partitioners are functions that tell the partition algorithm 1)
what to try to reduce 2) how to measure how much information is lost from
the reduction and 3) how to reduce the data. In partition, functions that
handle 1) are called directors, functions that handle 2) are called
metrics,  and functions that handle 3) are called reducers. partition has a
number of pre-specified partitioners for agglomerative data reduction.
Custom partitioners can be created with \code{\link[=as_partitioner]{as_partitioner()}}.

Pass \code{partitioner} objects to the \code{partitioner} argument of \code{\link[=partition]{partition()}}.
}
\examples{

as_partitioner(
  direct = direct_distance_pearson,
  measure = measure_icc,
  reduce = reduce_scaled_mean
)

}
\seealso{
Other partitioners: \code{\link{part_icc}},
  \code{\link{part_kmeans}}, \code{\link{part_minr2}},
  \code{\link{part_pc1}}, \code{\link{part_stdmi}},
  \code{\link{replace_partitioner}}
}
\concept{partitioners}
