% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional_hazards_glmnet.R
\name{details_proportional_hazards_glmnet}
\alias{details_proportional_hazards_glmnet}
\title{Proportional hazards regression}
\description{
\code{\link[glmnet:glmnet]{glmnet::glmnet()}} fits a regularized Cox proportional hazards model.
}
\details{
For this engine, there is a single mode: censored regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: see below)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 1.0)
}

The \code{penalty} parameter has no default and requires a single numeric
value. For more details about this, and the \code{glmnet} model in general,
see \link{glmnet-details}. As for
\code{mixture}:
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0} specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating lasso
and ridge.
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

proportional_hazards(penalty = double(1), mixture = double(1)) \%>\% 
  set_engine("glmnet") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Proportional Hazards Model Specification (censored regression)
## 
## Main Arguments:
##   penalty = 0
##   mixture = double(1)
## 
## Computational engine: glmnet 
## 
## Model fit template:
## censored::coxnet_train(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), alpha = double(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one. By default, \code{\link[glmnet:glmnet]{glmnet::glmnet()}} uses
the argument \code{standardize = TRUE} to center and scale the data.
}

\subsection{Other details}{

The model does not fit an intercept.

The model formula (which is required) can include \emph{special} terms, such
as \code{\link[survival:strata]{survival::strata()}}. This allows the baseline
hazard to differ between groups contained in the function. The column
used inside \code{strata()} is treated as qualitative no matter its type.
This is different than the syntax offered by the
\code{\link[glmnet:glmnet]{glmnet::glmnet()}} package (i.e.,
\code{\link[glmnet:stratifySurv]{glmnet::stratifySurv()}}) which is not
recommended here.

For example, in this model, the numeric column \code{rx} is used to estimate
two different baseline hazards for each value of the column:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(survival)
library(censored)
library(dplyr)
library(tidyr)

mod <- 
  proportional_hazards(penalty = 0.01) \%>\% 
  set_engine("glmnet", nlambda = 5) \%>\% 
  fit(Surv(futime, fustat) ~ age + ecog.ps + strata(rx), data = ovarian)

pred_data <- data.frame(age = c(50, 50), ecog.ps = c(1, 1), rx = c(1, 2))

# Different survival probabilities for different values of 'rx'
predict(mod, pred_data, type = "survival", time = 500) \%>\% 
  bind_cols(pred_data) \%>\% 
  unnest(.pred)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 2 × 5
##   .time .pred_survival   age ecog.ps    rx
##   <dbl>          <dbl> <dbl>   <dbl> <dbl>
## 1   500          0.666    50       1     1
## 2   500          0.769    50       1     2
}\if{html}{\out{</div>}}

Note that columns used in the \code{strata()} function \emph{will} also be
estimated in the regular portion of the model (i.e., within the linear
predictor).

Predictions of type \code{"time"} are predictions of the mean survival time.
}

\subsection{Linear predictor values}{

Since risk regression and parametric survival models are modeling
different characteristics (e.g. relative hazard versus event time),
their linear predictors will be going in opposite directions.

For example, for parametric models, the linear predictor \emph{increases with
time}. For proportional hazards models the linear predictor \emph{decreases
with time} (since hazard is increasing). As such, the linear predictors
for these two quantities will have opposite signs.

tidymodels does not treat different models differently when computing
performance metrics. To standardize across model types, the default for
proportional hazards models is to have \emph{increasing values with time}. As
a result, the sign of the linear predictor will be the opposite of the
value produced by the \code{predict()} method in the engine package.

This behavior can be changed by using the \code{increasing} argument when
calling \code{predict()} on a model object.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}
}
\section{References}{
\itemize{
\item Simon N, Friedman J, Hastie T, Tibshirani R. 2011. “Regularization
Paths for Cox’s Proportional Hazards Model via Coordinate Descent.”
\emph{Journal of Statistical Software}, Articles 39 (5): 1–13. .
\item Hastie T, Tibshirani R, Wainwright M. 2015. \emph{Statistical Learning with
Sparsity}. CRC Press.
\item Kuhn M, Johnson K. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}

\keyword{internal}
