% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_gls.R
\name{details_linear_reg_gls}
\alias{details_linear_reg_gls}
\title{Linear regression via generalized least squares}
\description{
The \code{"gls"} engine estimates linear regression for models where the rows of the
data are not independent.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has no tuning parameters.
}

\subsection{Translation from parsnip to the original package}{

The \strong{multilevelmod} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(multilevelmod)

linear_reg() \%>\% 
  set_engine("gls") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Computational engine: gls 
## 
## Model fit template:
## nlme::gls(formula = missing_arg(), data = missing_arg())
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

There are no specific preprocessing needs. However, it is helpful to
keep the clustering/subject identifier column as factor or character
(instead of making them into dummy variables). See the examples in the
next section.
}

\subsection{Other details}{

The model can accept case weights.

With parsnip, we suggest using the \emph{fixed effects} formula method when
fitting, but the details of the correlation structure should be passed
to \code{set_engine()} since it is an irregular (but required) argument:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)
# load nlme to be able to use the `cor*()` functions
library(nlme)

data("riesby")

linear_reg() \%>\% 
  set_engine("gls", correlation =  corCompSymm(form = ~ 1 | subject)) \%>\% 
  fit(depr_score ~ week, data = riesby)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## parsnip model object
## 
## Generalized least squares fit by REML
##   Model: depr_score ~ week 
##   Data: data 
##   Log-restricted-likelihood: -765.0148
## 
## Coefficients:
## (Intercept)        week 
##   -4.953439   -2.119678 
## 
## Correlation Structure: Compound symmetry
##  Formula: ~1 | subject 
##  Parameter estimate(s):
##       Rho 
## 0.6820145 
## Degrees of freedom: 250 total; 248 residual
## Residual standard error: 6.868785
}\if{html}{\out{</div>}}

When using tidymodels infrastructure, it may be better to use a
workflow. In this case, you can add the appropriate columns using
\code{add_variables()} then supply the typical formula when adding the model:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)

gls_spec <- 
  linear_reg() \%>\% 
  set_engine("gls", correlation =  corCompSymm(form = ~ 1 | subject))

gls_wflow <- 
  workflow() \%>\% 
  # The data are included as-is using:
  add_variables(outcomes = depr_score, predictors = c(week, subject)) \%>\% 
  add_model(gls_spec, formula = depr_score ~ week)

fit(gls_wflow, data = riesby)
}\if{html}{\out{</div>}}
}
}
\section{Degrees of freedom}{
Note that \code{\link[nlme:lme]{nlme::lme()}} and \code{\link[nlme:gls]{nlme::gls()}}
can fit the same model but will count degrees of freedom differently. If
there are \code{n} data points, \code{p} fixed effects parameters, and \code{q} random
effect parameters, the residual degrees of freedom are:
\itemize{
\item \strong{lme}: n - p - q
\item \strong{gls}: n - p
}

As a result, p-values will be different. For example, we can fit the
same model using different estimation methods (assuming a positive
covariance value):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gls_fit <- 
  linear_reg() \%>\% 
  set_engine("gls", correlation =  corCompSymm(form = ~ 1 | subject)) \%>\% 
  fit(depr_score ~ week, data = riesby)

lme_fit <-
  linear_reg() \%>\% 
  set_engine("lme", random =  ~ 1 | subject) \%>\% 
  fit(depr_score ~ week, data = riesby)
}\if{html}{\out{</div>}}

The estimated within-subject correlations are the same:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(ape)

# lme, use ape package:
lme_within_sub <- varcomp(lme_fit$fit)/sum(varcomp(lme_fit$fit))
lme_within_sub["subject"]
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##   subject 
## 0.6820145
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# gls:
summary(gls_fit$fit$modelStruct)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Correlation Structure: Compound symmetry
##  Formula: ~1 | subject 
##  Parameter estimate(s):
##       Rho 
## 0.6820145
}\if{html}{\out{</div>}}

as are the fixed effects (and their standard errors):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nlme::fixef(lme_fit$fit)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## (Intercept)        week 
##   -4.953439   -2.119678
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{coef(gls_fit$fit)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## (Intercept)        week 
##   -4.953439   -2.119678
}\if{html}{\out{</div>}}

However, the p-values for the fixed effects are different:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(broom.mixed)

# lme:
lme_fit \%>\% tidy() \%>\% 
  dplyr::filter(group == "fixed") \%>\% 
  dplyr::select(-group, -effect)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 0 × 6
## # … with 6 variables: term <chr>, estimate <dbl>, std.error <dbl>, df <dbl>,
## #   statistic <dbl>, p.value <dbl>
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# gls:
gls_fit \%>\% tidy()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 2 × 5
##   term        estimate std.error statistic  p.value
##   <chr>          <dbl>     <dbl>     <dbl>    <dbl>
## 1 (Intercept)    -4.95     0.808     -6.13 3.50e- 9
## 2 week           -2.12     0.224     -9.47 2.26e-18
}\if{html}{\out{</div>}}
\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item J Pinheiro, and D Bates. 2000. \emph{Mixed-effects models in S and
S-PLUS}. Springer, New York, NY
}
}
}

\keyword{internal}
