% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_additive_mod.R
\name{gen_additive_mod}
\alias{gen_additive_mod}
\title{Generalized additive models (GAMs)}
\usage{
gen_additive_mod(
  mode = "unknown",
  select_features = NULL,
  adjust_deg_free = NULL,
  engine = "mgcv"
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{select_features}{\code{TRUE} or \code{FALSE.} If \code{TRUE}, the model has the
ability to eliminate a predictor (via penalization). Increasing
\code{adjust_deg_free} will increase the likelihood of removing predictors.}

\item{adjust_deg_free}{If \code{select_features = TRUE}, then acts as a multiplier
for smoothness. Increase this beyond 1 to produce smoother models.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{gen_additive_mod()} defines a model that can use smoothed functions of
numeric predictors in a generalized linear model.

There are different ways to fit this model. See the engine-specific pages
for more details

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("gen_additive_mod")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit.model_spec()}} function is used
with the data.
}
\examples{
show_engines("gen_additive_mod")

gen_additive_mod()

}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Models with R}}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("gen_additive_mod")}
}
