% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_linear.R
\name{svm_linear}
\alias{svm_linear}
\title{General interface for linear support vector machines}
\usage{
svm_linear(mode = "unknown", cost = NULL, margin = NULL)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{cost}{A positive number for the cost of predicting a sample within
or on the wrong side of the margin}

\item{margin}{A positive number for the epsilon in the SVM insensitive
loss function (regression only)}
}
\description{
\code{svm_linear()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or via Spark. The main arguments for the
model are:
\itemize{
\item \code{cost}: The cost of predicting a sample within or on the
wrong side of the margin.
\item \code{margin}: The epsilon in the SVM insensitive loss function
(regression only)
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and arguments can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"LiblineaR"} (the default) or \code{"kernlab"}
}
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are below:
\subsection{LiblineaR}{\if{html}{\out{<div class="r">}}\preformatted{svm_linear() \%>\% 
  set_engine("LiblineaR") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Linear Support Vector Machine Specification (regression)
## 
## Computational engine: LiblineaR 
## 
## Model fit template:
## LiblineaR::LiblineaR(x = missing_arg(), y = missing_arg(), wi = missing_arg(), 
##     type = 11, svr_eps = 0.1)
}\if{html}{\out{<div class="r">}}\preformatted{svm_linear() \%>\% 
  set_engine("LiblineaR") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Linear Support Vector Machine Specification (classification)
## 
## Computational engine: LiblineaR 
## 
## Model fit template:
## LiblineaR::LiblineaR(x = missing_arg(), y = missing_arg(), wi = missing_arg(), 
##     type = 1)
}

Note that the \code{LiblineaR} engine cannot produce class probabilities.
When optimizing the model using the \code{tune} package, the default metrics
require class probabilities. To be able to use the \verb{tune_*()} functions,
a metric set must be passed as an argument and it can only contain
metrics associated with hard class predictions (e.g., accuracy and so
on).

This engine fits models that are L2-regularized for L2-loss. In the
\code{LiblineaR} documentation, these are types 1 (classification) and 11
(regression).
}

\subsection{kernlab}{\if{html}{\out{<div class="r">}}\preformatted{svm_linear() \%>\% 
  set_engine("kernlab") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Linear Support Vector Machine Specification (regression)
## 
## Computational engine: kernlab 
## 
## Model fit template:
## kernlab::ksvm(x = missing_arg(), data = missing_arg(), kernel = "vanilladot")
}\if{html}{\out{<div class="r">}}\preformatted{svm_linear() \%>\% 
  set_engine("kernlab") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Linear Support Vector Machine Specification (classification)
## 
## Computational engine: kernlab 
## 
## Model fit template:
## kernlab::ksvm(x = missing_arg(), data = missing_arg(), kernel = "vanilladot", 
##     prob.model = TRUE)
}

\code{fit()} passes the data directly to \code{kernlab::ksvm()} so that its
formula method can create dummy variables as-needed.
}

\subsection{Parameter translations}{

The standardized parameter names in parsnip can be mapped to their
original names in each engine that has main parameters. Each engine
typically has a different default value (shown in parentheses) for each
parameter.\tabular{lll}{
   \strong{parsnip} \tab \strong{LiblineaR} \tab \strong{kernlab} \cr
   cost \tab C (1) \tab C (1) \cr
   margin \tab svr_eps (0.1) \tab epsilon (0.1) \cr
}

}
}

\examples{
show_engines("svm_linear")

svm_linear(mode = "classification")
# Parameters can be represented by a placeholder:
svm_linear(mode = "regression", cost = varying())
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=set_engine]{set_engine()}}, \code{\link[=update]{update()}}
}
