% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree.R
\name{C5.0_train}
\alias{C5.0_train}
\title{Boosted trees via C5.0}
\usage{
C5.0_train(x, y, weights = NULL, trials = 15, minCases = 2, sample = 0, ...)
}
\arguments{
\item{x}{A data frame or matrix of predictors.}

\item{y}{A factor vector with 2 or more levels}

\item{weights}{An optional numeric vector of case weights. Note
that the data used for the case weights will not be used as a
splitting variable in the model (see
\url{http://www.rulequest.com/see5-win.html} for
Quinlan's notes on case weights).}

\item{trials}{An integer specifying the number of boosting
iterations. A value of one indicates that a single model is
used.}

\item{minCases}{An integer for the smallest number of samples
that must be put in at least two of the splits.}

\item{sample}{A value between (0, .999) that specifies the
random proportion of the data should be used to train the model.
By default, all the samples are used for model training. Samples
not used for training are used to evaluate the accuracy of the
model in the printed output.}

\item{...}{Other arguments to pass.}
}
\value{
A fitted C5.0 model.
}
\description{
\code{C5.0_train} is a wrapper for the \code{C5.0()} function in the
\pkg{C50} package that fits tree-based models
where all of the model arguments are in the main function.
}
\keyword{internal}
