% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_poly.R
\name{svm_poly}
\alias{svm_poly}
\alias{update.svm_poly}
\title{General interface for polynomial support vector machines}
\usage{
svm_poly(mode = "unknown", cost = NULL, degree = NULL,
  scale_factor = NULL, margin = NULL)

\method{update}{svm_poly}(object, parameters = NULL, cost = NULL,
  degree = NULL, scale_factor = NULL, margin = NULL, fresh = FALSE,
  ...)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{cost}{A positive number for the cost of predicting a sample within
or on the wrong side of the margin}

\item{degree}{A positive number for polynomial degree.}

\item{scale_factor}{A positive number for the polynomial scaling factor.}

\item{margin}{A positive number for the epsilon in the SVM insensitive
loss function (regression only)}

\item{object}{A polynomial SVM model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{svm_poly()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or via Spark. The main arguments for the
model are:
\itemize{
\item \code{cost}: The cost of predicting a sample within or on the
wrong side of the margin.
\item \code{degree}: The polynomial degree.
\item \code{scale_factor}: A scaling factor for the kernel.
\item \code{margin}: The epsilon in the SVM insensitive loss function
(regression only)
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"kernlab"}  (the default)
}
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call. For this type of
model, the template of the fit calls are::

\pkg{kernlab} classification

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::svm_poly(mode = "classification"), "kernlab")}

\pkg{kernlab} regression

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::svm_poly(mode = "regression"), "kernlab")}
}

\examples{
svm_poly(mode = "classification", degree = 1.2)
# Parameters can be represented by a placeholder:
svm_poly(mode = "regression", cost = varying())
model <- svm_poly(cost = 10, scale_factor = 0.1)
model
update(model, cost = 1)
update(model, cost = 1, fresh = TRUE)
}
\seealso{
[\code{\link[=fit]{fit()}}
}
