% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arguments.R
\name{set_args}
\alias{set_args}
\alias{set_mode}
\title{Change elements of a model specification}
\usage{
set_args(object, ...)

set_mode(object, mode)
}
\arguments{
\item{object}{A model specification.}

\item{...}{One or more named model arguments.}

\item{mode}{A character string for the model type (e.g. "classification" or
"regression")}
}
\value{
An updated model object.
}
\description{
\code{set_args} can be used to modify the arguments of a model specification while
\code{set_mode} is used to change the model's mode.
}
\details{
\code{set_args} will replace existing values of the arguments.
}
\examples{
rand_forest()

rand_forest() \%>\%
  set_args(mtry = 3, importance = TRUE) \%>\%
  set_mode("regression")

}
