% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parse_data.R
\name{get_parse_data}
\alias{get_parse_data}
\alias{parse-data}
\alias{get_parse_data.srcfile}
\alias{get_parse_data.srcref}
\alias{get_parse_data.function}
\alias{valid_parse_data}
\alias{as_parse_data}
\title{Parse Data}
\usage{
get_parse_data(x, ...)

\method{get_parse_data}{srcfile}(x, ...)

\method{get_parse_data}{srcref}(x, ..., ignore.groups = TRUE,
  include.doc.comments = TRUE, include.regular.comments = FALSE)

\method{get_parse_data}{function}(x, ...)

valid_parse_data(df)

as_parse_data(df)
}
\arguments{
\item{x}{an object to get parse-data from.}

\item{...}{options for specific type of objects.}

\item{ignore.groups}{Should \link[=pd_is_grouping]{groupings} be ignored?}

\item{include.doc.comments}{include associated documentation comments.}

\item{include.regular.comments}{include associated regular comments.}

\item{df}{a data.frame object.}
}
\description{
Parsing data is at the core of parse tools and thus at the core
of the documentation package. The \code{get_parse_data} function is
essentially a customized version of \code{<getParseData>} that will return
a cleaned up version of the parse data for a variety of objects.
This version also fails less often, even reparsing text when
needed.

\subsection{valid_parse_data}{
The \code{valid_parse_data} function tests if the object \code{df}
conforms to the expected conventions of a \code{parse-data} object.
Returns TRUE if valid otherwise returns the reason it is not valid.
}

\subsection{as_parse_data}{
The \code{as_parse_data} function tests if a data frame is valid through
\code{valid_parse_data} then returns the data with the comments
classified, as is expected for parse-data objects.  All parse data for
use with parsetools functions should be obtained either through
get_parse_data or converted through as_parse_data.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{function}: Get parse information from a function.
The function must have a \code{\link[base:srcref]{srcref}}.
}}

\examples{
    text <- "    my_function <- function(object #< An object to do something with
            ){
        #' A title
        #'
        #' A Description
        print(\\"It Works!\\")
        #< A return value.
    }"
    source(textConnection(text), keep.source = TRUE)

    # Get parse data from a function
    (pd <- get_parse_data(my_function))
    # which must have a srcref attribute.
    # You can call the get_parse data directly on the srcref object.
    src <- utils::getSrcref(my_function)
    pd2 <- get_parse_data(src)

    identical(pd, pd2)

    # Objects must have a srcref.
    utils::getSrcref(rnorm)
    tools::assertError(get_parse_data(rnorm), TRUE)
}
