% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSim.R
\name{markerSim}
\alias{markerSim}
\title{Marker simulation}
\usage{
markerSim(x, N = 1, available = NULL, alleles = NULL, afreq = NULL,
  partialmarker = NULL, loop_breakers = NULL, eliminate = 0,
  seed = NULL, verbose = TRUE)
}
\arguments{
\item{x}{a \code{\link{linkdat}} object}

\item{N}{a positive integer: the number of markers to be simulated}

\item{available}{a vector containing IDs of the available individuals, i.e.
those whose genotypes should be simulated. 
By default, all individuals are included.}

\item{alleles}{a vector containing the alleles for the marker to be
simulation. If a single integer is given, this is interpreted as the number
of alleles, and the actual alleles as \code{1:alleles}. Must be NULL if
\code{partialmarker} is non-NULL.}

\item{afreq}{a vector of length 2 containing the population frequencies for
the marker alleles. Must be NULL if \code{partialmarker} is non-NULL.}

\item{partialmarker}{Either NULL (resulting in unconditional simulation), a
marker object (on which the simulation should be conditioned) or the index
of an existing marker of \code{x}.}

\item{loop_breakers}{a numeric containing IDs of individuals to be used as
loop breakers. Relevant only if the pedigree has loops, and only if
\code{partialmarker} is non-NULL. See \code{\link{breakLoops}}.}

\item{eliminate}{A non-negative integer, indicating the number of iterations
in the internal genotype-compatibility algorithm. Positive values can save
time if \code{partialmarker} is non-NULL and the number of alleles is large.}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{verbose}{a logical.}
}
\value{
a \code{linkdat} object equal to \code{x} except its
\code{markerdata} entry, which consists of the \code{N} simulated markers.
}
\description{
Simulates marker genotypes conditional on the pedigree structure, affection
statuses and disease model.
}
\details{
This implements (with various time savers) the algorithm used in SLINK of
the LINKAGE/FASTLINK suite. If \code{partialmarker} is NULL, genotypes are
simulated by simple gene dropping, using \code{\link{simpleSim}}.
}
\examples{

x = nuclearPed(2)
partial = marker(x, 3, 1, alleles=1:3)
markerSim(x, N=1, alleles=1:3)
markerSim(x, N=1, partialmarker=partial)
markerSim(x, N=1, partialmarker=partial)
markerSim(x, N=1, available=4, partialmarker=partial)

}
\references{
G. M. Lathrop, J.-M. Lalouel, C. Julier, and J. Ott,
\emph{Strategies for Multilocus Analysis in Humans}, PNAS 81(1984), pp.
3443-3446.
}
\seealso{
\code{\link{simpleSim}}, \code{\link{linkage.power}}
}
\author{
Magnus Dehli Vigeland
}
