\name{twoMarkerDistribution}
\alias{twoMarkerDistribution}
\title{
Genotype probability distribution
}
\description{
Computes the joint genotype distribution of two markers for a specified pedigree member, conditional on existing genotypes and pedigree information. 
}
\usage{
twoMarkerDistribution(x, id, partialmarker1, partialmarker2, theta, 
                      loop_breakers=NULL, eliminate=99, verbose=TRUE)
}

\arguments{
  \item{x}{
A \code{\link{linkdat}} object.
}
  \item{id}{
The individual in question.
}
  \item{partialmarker1, partialmarker2}{
Either a single integer indicating the number of one of \code{x}'s existing markers, or a \code{marker} object.
}
  \item{theta}{
A single numeric in the interval [0, 0.5] - the recombination fraction between the two markers.
}
  \item{loop_breakers}{
A numeric containing IDs of individuals to be used as loop breakers. Relevant only if the pedigree has loops. See \code{\link{breakLoops}}.
}
 \item{eliminate}{
A non-negative integer, indicating the number of iterations in the internal genotype-compatibility algorithm. Positive values can save time if \code{partialmarker} is non-empty and the number of alleles is large.
}
  \item{verbose}{
A logical.
}
}
\value{
A named matrix giving the joint genotype distribution.
}
\author{
Magnus Dehli Vigeland
}

\seealso{
\code{\link{oneMarkerDistribution}}
}
\examples{
x = nuclearPed(2)
emptySNP = marker(x, alleles=c('a','b'))
SNP1 = marker(x, 1, c(1,1), 2, c(1,0), alleles=1:2, afreq=c(0.1, 0.9))
twoMarkerDistribution(x, id=2, emptySNP, SNP1, theta=0)
twoMarkerDistribution(x, id=2, emptySNP, SNP1, theta=0.5)
twoMarkerDistribution(x, id=3, emptySNP, SNP1, theta=0.5)

# X-linked example
SNPX_1 = marker(x, 2, c('a','b'), 3, 'b', alleles=c('a','b'), chrom=23)
SNPX_2 = marker(x, 2, c('a','b'), 3, 'b', alleles=c('a','b'), chrom=23)
r1 = twoMarkerDistribution(x, id=4, SNPX_1, SNPX_2, theta=0)
r2 = twoMarkerDistribution(x, id=4, SNPX_1, SNPX_2, theta=0.5)
stopifnot(all(r1==c(.5,0,0,.5)), all(r2==c(.25,.25,.25,.25)))

}
\keyword{ distributions }