% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resid_df.R
\name{get_resid_df}
\alias{get_resid_df}
\title{Extract residuals from multiple models.}
\usage{
get_resid_df(model_list, model_names = NULL)
}
\arguments{
\item{model_list}{A list of regression models.}

\item{model_names}{A list of names for the regression models (default is
\code{NULL}).}
}
\value{
A data frame of residuals and their corresponding model names.
}
\description{
Extracts residuals from multiple models and returns them as a data frame.
}
\details{
This function is used within \code{residual_plots} and is not likely to be of
much use to end users.
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 paramhetero:::get_resid_df(model_list = mList)

}
