% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_cplm.R, R/methods_pscl.R
\name{p_value.zcpglm}
\alias{p_value.zcpglm}
\alias{p_value.zeroinfl}
\title{p-values for Models with Zero-Inflation}
\usage{
\method{p_value}{zcpglm}(model, component = c("all", "conditional", "zi", "zero_inflated"), ...)

\method{p_value}{zeroinfl}(
  model,
  component = c("all", "conditional", "zi", "zero_inflated"),
  method = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{component}{Model component for which parameters should be shown. See
the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} or
\code{\link[=p_value]{p_value()}} for further details.}

\item{...}{Additional arguments}

\item{method}{Method for computing degrees of freedom for
confidence intervals (CI) and the related p-values. Allowed are following
options (which vary depending on the model class): \code{"residual"},
\code{"normal"}, \code{"likelihood"}, \code{"satterthwaite"}, \code{"kenward"}, \code{"wald"},
\code{"profile"}, \code{"boot"}, \code{"uniroot"}, \code{"ml1"}, \code{"betwithin"}, \code{"hdi"},
\code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, or \code{"bcai"}. See section
\emph{Confidence intervals and approximation of degrees of freedom} in
\code{\link[=model_parameters]{model_parameters()}} for further details.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame with at least two columns: the parameter names and the p-values.
Depending on the model, may also include columns for model components etc.
}
\description{
This function attempts to return, or compute, p-values of hurdle and
zero-inflated models.
}
\examples{
if (require("pscl", quietly = TRUE)) {
  data("bioChemists")
  model <- zeroinfl(art ~ fem + mar + kid5 | kid5 + phd, data = bioChemists)
  p_value(model)
  p_value(model, component = "zi")
}
}
