% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_lavaan.R
\name{model_parameters.lavaan}
\alias{model_parameters.lavaan}
\title{Parameters from CFA/SEM models}
\usage{
\method{model_parameters}{lavaan}(
  model,
  ci = 0.95,
  standardize = FALSE,
  component = c("regression", "correlation", "loading", "defined"),
  keep = NULL,
  drop = NULL,
  parameters = keep,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{CFA or SEM created by the \code{lavaan::cfa} or \code{lavaan::sem}
functions.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{standardize}{Return standardized parameters (standardized coefficients).
Can be \code{TRUE} (or \code{"all"} or \code{"std.all"}) for standardized
estimates based on both the variances of observed and latent variables;
\code{"latent"} (or \code{"std.lv"}) for standardized estimates based
on the variances of the latent variables only; or \code{"no_exogenous"}
(or \code{"std.nox"}) for standardized estimates based on both the
variances of observed and latent variables, but not the variances of
exogenous covariates. See \code{lavaan::standardizedsolution} for details.}

\item{component}{What type of links to return. Can be \code{"all"} or some of \code{c("regression", "correlation", "loading", "variance", "mean")}.}

\item{keep}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{keep} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{drop}{See \code{keep}.}

\item{parameters}{Deprecated, alias for \code{keep}.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Format CFA/SEM objects from the lavaan package (Rosseel, 2012; Merkle and Rosseel 2018).
}
\note{
There is also a \href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
library(parameters)

# lavaan -------------------------------------
if (require("lavaan", quietly = TRUE)) {

  # Confirmatory Factor Analysis (CFA) ---------

  structure <- " visual  =~ x1 + x2 + x3
                 textual =~ x4 + x5 + x6
                 speed   =~ x7 + x8 + x9 "
  model <- lavaan::cfa(structure, data = HolzingerSwineford1939)
  model_parameters(model)
  model_parameters(model, standardize = TRUE)

  # filter parameters
  model_parameters(
    model,
    parameters = list(
      To = "^(?!visual)",
      From = "^(?!(x7|x8))"
    )
  )

  # Structural Equation Model (SEM) ------------

  structure <- "
    # latent variable definitions
      ind60 =~ x1 + x2 + x3
      dem60 =~ y1 + a*y2 + b*y3 + c*y4
      dem65 =~ y5 + a*y6 + b*y7 + c*y8
    # regressions
      dem60 ~ ind60
      dem65 ~ ind60 + dem60
    # residual correlations
      y1 ~~ y5
      y2 ~~ y4 + y6
      y3 ~~ y7
      y4 ~~ y8
      y6 ~~ y8
  "
  model <- lavaan::sem(structure, data = PoliticalDemocracy)
  model_parameters(model)
  model_parameters(model, standardize = TRUE)
}
}
\references{
\itemize{
\item Rosseel Y (2012). lavaan: An R Package for Structural Equation
Modeling. Journal of Statistical Software, 48(2), 1-36.
\item Merkle EC , Rosseel Y (2018). blavaan: Bayesian Structural Equation
Models via Parameter Expansion. Journal of Statistical Software, 85(4),
1-30. http://www.jstatsoft.org/v85/i04/
}
}
