% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_model.R
\name{bootstrap_model}
\alias{bootstrap_model}
\alias{bootstrap_model.default}
\alias{bootstrap_model.merMod}
\title{Model bootstrapping}
\usage{
bootstrap_model(model, iterations = 1000, ...)

\method{bootstrap_model}{default}(
  model,
  iterations = 1000,
  type = "ordinary",
  parallel = c("no", "multicore", "snow"),
  n_cpus = 1,
  verbose = FALSE,
  ...
)

\method{bootstrap_model}{merMod}(
  model,
  iterations = 1000,
  type = "parametric",
  parallel = c("no", "multicore", "snow"),
  n_cpus = 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{Statistical model.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{...}{Arguments passed to or from other methods.}

\item{type}{Character string specifying the type of bootstrap. For mixed models
of class \code{merMod} or \code{glmmTMB}, may be \code{"parametric"} (default) or
\code{"semiparametric"} (see \code{?lme4::bootMer} for details). For all
other models, see argument \code{sim} in \code{?boot::boot} (defaults to
\code{"ordinary"}).}

\item{parallel}{The type of parallel operation to be used (if any).}

\item{n_cpus}{Number of processes to be used in parallel operation.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame of bootstrapped estimates.
}
\description{
Bootstrap a statistical model n times to return a data frame of estimates.
}
\details{
By default, \code{boot::boot()} is used to generate bootstraps from
the model data, which are then used to \code{update()} the model, i.e. refit
the model with the bootstrapped samples. For \code{merMod} objects (\pkg{lme4})
or models from \pkg{glmmTMB}, the \code{lme4::bootMer()} function is used to
obtain bootstrapped samples. \code{bootstrap_parameters()} summarizes the
bootstrapped model estimates.
}
\section{Using with \code{emmeans}}{

The output can be passed directly to the various functions from the
\code{emmeans} package, to obtain bootstrapped estimates, contrasts, simple
slopes, etc. and their confidence intervals. These can then be passed to
\code{model_parameter()} to obtain standard errors, p-values, etc (see
example).
\cr\cr
Note that that p-values returned here are estimated under the assumption of
\emph{translation equivariance}: that shape of the sampling distribution is
unaffected by the null being true or not. If this assumption does not hold,
p-values can be biased, and it is suggested to use proper permutation tests
to obtain non-parametric p-values.
}

\examples{
\dontrun{
if (require("boot", quietly = TRUE)) {
  model <- lm(mpg ~ wt + factor(cyl), data = mtcars)
  b <- bootstrap_model(model)
  print(head(b))

  if (require("emmeans")) {
    est <- emmeans(b, consec ~ cyl)
    print(model_parameters(est))
  }
}
}
}
\seealso{
\code{\link{bootstrap_parameters}}, \code{\link{simulate_model}}, \code{\link{simulate_parameters}}
}
