% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_parameters.R
\name{pool_parameters}
\alias{pool_parameters}
\title{Pool Model Parameters}
\usage{
pool_parameters(
  x,
  exponentiate = FALSE,
  component = "conditional",
  details = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A list of \code{parameters_model} objects, as returned by
\code{\link{model_parameters}}, or a list of model-objects that is
supported by \code{model_parameters()}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for,
say, logistic regressions, or more generally speaking: for models with log
or logit link. \strong{Note:} standard errors are also transformed (by
multiplying the standard errors with the exponentiated coefficients), to
mimic behaviour of other software packages, such as Stata. For
\code{compare_parameters()}, \code{exponentiate = "nongaussian"} will only
exponentiate coefficients for all models except those from Gaussian family.}

\item{component}{Model component for which parameters should be shown. May be
one of \code{"conditional"}, \code{"precision"} (\pkg{betareg}),
\code{"scale"} (\pkg{ordinal}), \code{"extra"} (\pkg{glmx}),
\code{"marginal"} (\pkg{mfx}), \code{"conditional"} or \code{"full"} (for
\code{MuMIn::model.avg()}) or \code{"all"}.}

\item{details}{Logical, if \code{TRUE}, a summary of the random effects is included. See \code{\link{random_parameters}} for details.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Currently not used.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
This function "pools" (i.e. combines) model parameters in a similar fashion
as \code{mice::pool()}. However, this function pools parameters from
\code{parameters_model} objects, as returned by
\code{\link{model_parameters}}.
}
\details{
Averaging of parameters follows Rubin's rules (\cite{Rubin, 1987, p. 76}).
  The pooled degrees of freedom is based on the Barnard-Rubin adjustment for
  small samples (\cite{Barnard and Rubin, 1999}).
}
\note{
Models with multiple components, (for instance, models with zero-inflation,
  where predictors appear in the count and zero-inflated part) may fail in
  case of identical names for coefficients in the different model components,
  since the coefficient table is grouped by coefficient names for pooling. In
  such cases, coefficients of count and zero-inflated model parts would be
  combined. Therefore, the \code{component} argument defaults to
  \code{"conditional"} to avoid this.
}
\examples{
# example for multiple imputed datasets
if (require("mice")) {
  data("nhanes2")
  imp <- mice(nhanes2, printFlag = FALSE)
  models <- lapply(1:5, function(i) {
    lm(bmi ~ age + hyp + chl, data = complete(imp, action = i))
  })
  pool_parameters(models)

  # should be identical to:
  m <- with(data = imp, exp = lm(bmi ~ age + hyp + chl))
  summary(pool(m))
}
}
\references{
Barnard, J. and Rubin, D.B. (1999). Small sample degrees of freedom with
multiple imputation. Biometrika, 86, 948-955. Rubin, D.B. (1987). Multiple
Imputation for Nonresponse in Surveys. New York: John Wiley and Sons.
}
