% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ci.R, R/methods_DirichletReg.R,
%   R/methods_betareg.R, R/methods_glmmTMB.R, R/methods_lme4.R,
%   R/methods_mass.R, R/methods_mfx.R, R/methods_mixmod.R, R/methods_mixor.R,
%   R/methods_nlme.R, R/methods_ordinal.R, R/methods_pscl.R, R/methods_spaMM.R
\name{ci.default}
\alias{ci.default}
\alias{ci.glm}
\alias{ci.DirichletRegModel}
\alias{ci.betareg}
\alias{ci.glmmTMB}
\alias{ci.merMod}
\alias{ci.polr}
\alias{ci.poissonmfx}
\alias{ci.betamfx}
\alias{ci.MixMod}
\alias{ci.mixor}
\alias{ci.lme}
\alias{ci.clm2}
\alias{ci.zeroinfl}
\alias{ci.hurdle}
\alias{ci.HLfit}
\title{Confidence Intervals (CI)}
\usage{
\method{ci}{default}(x, ci = 0.95, dof = Inf, method = NULL, ...)

\method{ci}{glm}(x, ci = 0.95, method = c("profile", "wald", "robust"), ...)

\method{ci}{DirichletRegModel}(x, ci = 0.95, component = c("all", "conditional", "precision"), ...)

\method{ci}{betareg}(x, ci = 0.95, component = c("all", "conditional", "precision"), ...)

\method{ci}{glmmTMB}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  method = c("wald", "ml1", "betwithin", "robust", "profile", "uniroot"),
  verbose = TRUE,
  ...
)

\method{ci}{merMod}(
  x,
  ci = 0.95,
  method = c("wald", "ml1", "betwithin", "satterthwaite", "kenward", "boot", "profile"),
  ...
)

\method{ci}{polr}(x, ci = 0.95, method = c("profile", "wald", "robust"), ...)

\method{ci}{poissonmfx}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "marginal"),
  method = NULL,
  ...
)

\method{ci}{betamfx}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "precision", "marginal"),
  method = NULL,
  ...
)

\method{ci}{MixMod}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated"),
  verbose = TRUE,
  ...
)

\method{ci}{mixor}(x, ci = 0.95, effects = c("all", "fixed", "random"), ...)

\method{ci}{lme}(x, ci = 0.95, method = c("wald", "betwithin", "ml1", "satterthwaite"), ...)

\method{ci}{clm2}(x, ci = 0.95, component = c("all", "conditional", "scale"), ...)

\method{ci}{zeroinfl}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  method = c("wald", "ml1", "betwithin", "robust", "profile", "uniroot"),
  verbose = TRUE,
  ...
)

\method{ci}{hurdle}(
  x,
  ci = 0.95,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  method = c("wald", "ml1", "betwithin", "robust", "profile", "uniroot"),
  verbose = TRUE,
  ...
)

\method{ci}{HLfit}(
  x,
  ci = 0.95,
  method = c("wald", "ml1", "betwithin", "profile", "boot"),
  iterations = 100,
  ...
)
}
\arguments{
\item{x}{A statistical model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{dof}{Degrees of Freedom. If not specified, for \code{ci_wald()}, defaults to model's residual degrees of freedom (i.e. \code{n-k}, where \code{n} is the number of observations and \code{k} is the number of parameters). For \code{p_value_wald()}, defaults to \code{Inf}.}

\item{method}{For mixed models, can be \code{\link[=p_value_wald]{"wald"}} (default), \code{\link[=p_value_ml1]{"ml1"}} or \code{\link[=p_value_betwithin]{"betwithin"}}. For linear mixed model, can also be \code{\link[=p_value_satterthwaite]{"satterthwaite"}}, \code{\link[=p_value_kenward]{"kenward"}} or \code{"boot"} (see \code{lme4::confint.merMod}). For (generalized) linear models, can be \code{"robust"} to compute confidence intervals based on robust covariance matrix estimation, and for generalized linear models and models from packages \pkg{lme4} or \pkg{glmmTMB}, may also be \code{"profile"}, \code{"uniroot"} or \code{"wald"} (default).}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{verbose}{Toggle warnings and messages.}

\item{effects}{Should standard errors for fixed effects or random effects be
returned? Only applies to mixed models. May be abbreviated. When standard
errors for random effects are requested, for each grouping factor a list of
standard errors (per group level) for random intercepts and slopes is
returned.}

\item{iterations}{The number of draws to simulate/bootstrap.}
}
\value{
A data frame containing the CI bounds.
}
\description{
Compute confidence intervals (CI) for frequentist models.
}
\note{
\code{ci_robust()} resp. \code{ci(method = "robust")}
  rely on the \pkg{sandwich} or \pkg{clubSandwich} package (the latter if
  \code{vcov_estimation = "CR"} for cluster-robust standard errors) and will
  thus only work for those models supported by those packages.
}
\examples{
\donttest{
library(parameters)
if (require("glmmTMB")) {
  model <- glmmTMB(
    count ~ spp + mined + (1 | site),
    ziformula = ~mined,
    family = poisson(),
    data = Salamanders
  )

  ci(model)
  ci(model, component = "zi")
}
}
}
