% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_GH.R
\name{param_GH}
\alias{param_GH}
\alias{param_GH_h}
\alias{param_GH_g}
\title{Solve Tukey \eqn{g}-&-\eqn{h} Parameters from Moments}
\usage{
param_GH(mean = 0, sd = 1, skewness, kurtosis)

param_GH_h(sd = 1, kurtosis)

param_GH_g(mean = 0, sd = 1, skewness)
}
\arguments{
\item{mean}{\link[base]{numeric} scalar, mean, default value 0}

\item{sd}{\link[base]{numeric} scalar, standard deviation, default value 1}

\item{skewness}{\link[base]{numeric} scalar}

\item{kurtosis}{\link[base]{numeric} scalar}
}
\value{
Function \link{param_GH} returns a \link[base]{length}-4
\link[base]{numeric} \link[base]{vector} \eqn{(A, B, g, h)}.

Function \link{param_GH_h} returns a \link[base]{length}-2
\link[base]{numeric} \link[base]{vector} \eqn{(B, h)}.

Function \link{param_GH_g} returns a \link[base]{length}-3
\link[base]{numeric} \link[base]{vector} \eqn{(A, B, g)}.
}
\description{
Solve Tukey \eqn{g}-, \eqn{h}- and \eqn{g}-&-\eqn{h} distribution parameters
from mean, standard deviation, skewness and kurtosis.
}
\details{
Function \link{param_GH} solves the
location \eqn{A}, scale \eqn{B}, skewness \eqn{g}
and elongation \eqn{h} parameters of Tukey \eqn{g}-&-\eqn{h} distribution,
from user-specified mean \eqn{\mu}, standard deviation \eqn{\sigma},
skewness and kurtosis.

A education and demonstration function \link{param_GH_h} solves the
scale \eqn{B} and elongation \eqn{h} parameters of Tukey \eqn{h}-distribution,
from user-specified standard deviation \eqn{\sigma} and kurtosis.
This is a non-skewed distribution, thus
the location parameter \eqn{A} is the mean \eqn{\mu}, and the skewness parameter \eqn{g=0}.

A education and demonstration function \link{param_GH_g} solves the
location \eqn{A}, scale \eqn{B} and skewness \eqn{g} parameters of Tukey \eqn{g}-distribution,
from user-specified mean \eqn{\mu}, standard deviation \eqn{\sigma} and skewness.
For this distribution, the elongation parameter \eqn{h=0}.
}
\examples{
param_GH(skewness = .2, kurtosis = .3)

param_GH_h(kurtosis = .3)

param_GH_g(skewness = .2)

}
