% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{NumSilToClusterSil}
\alias{NumSilToClusterSil}
\title{NumSilToClusterSil}
\usage{
NumSilToClusterSil(cl, s)
}
\arguments{
\item{cl}{The array of classification with the number of the class to which each point belongs to. This number must be in 1..number_of_classes.\cr
This function takes something like the L$clasif array which is the second element of the list returned by ApplyPAM}

\item{s}{The numeric value of the silhouette for each point, with points in the same order as they appear in cl.\cr
This is the vector returned by after a call to CalculateSilhouette with the same value of parameter cl.}
}
\value{
sp       A silhouette in the format of the cluster package which is a NumericMatrix of as many rows as points and three columns: cluster, neighbor and sil_width.\cr
                 Its structure and dimension names are as in package 'cluster', which allows to use it with the silhouette plotting functions of such package\cr
                 This means you can do library(cluster) followed by plot(NumSilToClusterSil(cl,s)) to get a beatiful plot.
}
\description{
Takes a silhouette in the form of a NumericVector, as returned by CalculateSilhouette, and returns it as a numeric matrix appropriate to be plotted by the package 'cluster'
}
\examples{
# Synthetic problem: 10 random seeds with coordinates in [0..20]
# to which random values in [-0.1..0.1] are added
M<-matrix(0,100,500)
rownames(M)<-paste0("rn",c(1:100))
for (i in (1:10))
{
 p<-20*runif(500)
 Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
 for (k in (1:10))
 {
  M[10*(i-1)+k,]=p+Rf[k,]
 }
}
JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
sil <- CalculateSilhouette(L$clasif,"pamDL2.bin")
sp <- NumSilToClusterSil(L$clasif,sil)
# Here you can install and load package cluster and make plot(sp)
file.remove("pamtest.bin")
file.remove("pamDL2.bin")
}
