### Setting the Lookup Label

Welcome to the help page for setting the Lookup Label! This guide will help you understand how to create and use a lookup label for your annotation data.

#### About the Lookup Label

The lookup label is the text label used to identify the column for the lookup data in the annotations dataframe. It is important that this label is descriptive and follows specific formatting guidelines to ensure compatibility and clarity when exporting the data.

#### Requirements for the Lookup Label

-   **Descriptive**: The label should clearly describe the content or purpose of the lookup data.
-   **One Word Preferred**: Ideally, the label should be a single word for simplicity.
-   **No Spaces**: If multiple words are necessary, combine them without spaces. You can use camelCase or underscores to enhance readability (e.g., `lookupLabel` or `lookup_label`).

#### Importance of the Lookup Label

The lookup label becomes the heading of the column in the annotations dataframe when the data is exported. It is essential to choose a meaningful and clear label to facilitate understanding and usage of the data later.

#### Steps to Set the Lookup Label

1.  **Choose a Descriptive Word**: Think about the purpose of the lookup data and choose a word that accurately describes it.
2.  **Format the Label**: Ensure the label has no spaces. If you use multiple words, consider using camelCase or underscores for readability.
3.  **Enter the Label**: When prompted, enter the formatted label in the appropriate field or setting.

#### Examples

-   **Single Word**: `Species`, `Cover`, `Mortality`
-   **Multiple Words (No Spaces)**: `speciesName`, `percentageCover`, `percentageDead`

#### Troubleshooting

-   **Column Heading Confusion**: Choose a more descriptive or clear label if the heading in the annotations dataframe is not easily understood.

We hope this guide helps you effectively set your lookup label for your annotation data.
