% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest-utils.R
\name{nest_tdc}
\alias{nest_tdc}
\alias{nest_tdc.default}
\alias{nest_tdc.list}
\title{Create nested data frame from data with time-dependent covariates}
\usage{
nest_tdc(data, formula, ...)

\method{nest_tdc}{default}(data, formula, ...)

\method{nest_tdc}{list}(data, formula, ...)
}
\arguments{
\item{data}{A suitable data structure (e.g. unnested data frame with
concurrent TDCs or a list where each element is a data frame, potentially
containing TDCs as specified in the RHS of \code{formula}).
Only TDCs present in \code{formula} will be returned.}

\item{formula}{A two sided formula with a two part RHS, where the second
part indicates the structure of the TDC structure.}

\item{...}{Further arguments passed to methods.}
}
\description{
Provides methods to nest data with time-dependent covariates (TDCs).
A \code{formula} must be provided where the right hand side (RHS) contains
the structure of the TDCs
}
\keyword{internal}
