% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_functions.R
\name{get_surv_prob}
\alias{get_surv_prob}
\title{Calculate survival probabilities}
\usage{
get_surv_prob(newdata, object, ci = TRUE, ci_type = c("default",
  "delta", "sim"), se_mult = 2L, time_var = NULL,
  interval_length = "intlen", nsim = 100L, ...)
}
\arguments{
\item{newdata}{ A data frame or list containing the values of the model covariates at which predictions
  are required. If this is not provided then predictions corresponding to the
                original data are returned. If \code{newdata} is provided then
                it should contain all the variables needed for prediction: a
                warning is generated if not. See details for use with \code{link{linear.functional.terms}}. }

\item{object}{ a fitted \code{gam} object as produced by \code{gam()}.
                }

\item{ci}{Logical indicating whether to include confidence intervals. Defaults
to \code{TRUE}}

\item{se_mult}{Factor by which standard errors are multiplied for calculating
the confidence intervals.}

\item{time_var}{Name of the variable used for the baseline hazard. If
not given, defaults to \code{"tend"} for \code{\link[mgcv]{gam}} fits, else
\code{"interval"}. The latter is assumed to be a factor, the former
numeric.}

\item{interval_length}{The variable in newdata containing the interval lengths.
Can be either bare unquoted variable name or character. Defaults to \code{"intlen"}.}

\item{...}{Further arguments passed to \code{\link[mgcv]{predict.gam}} and
\code{\link{get_hazard}}}
}
\description{
Calculate survival probabilities
}
\keyword{internal}
