% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_functions.R
\name{get_hazard}
\alias{get_hazard}
\title{Calculate predicted hazard}
\usage{
get_hazard(newdata, object, ci = TRUE, type = c("response", "link"),
  ci_type = c("default", "delta", "sim"), time_var = NULL,
  se_mult = 2, ...)
}
\arguments{
\item{newdata}{ A data frame or list containing the values of the model covariates at which predictions
  are required. If this is not provided then predictions corresponding to the
                original data are returned. If \code{newdata} is provided then
                it should contain all the variables needed for prediction: a
                warning is generated if not. See details for use with \code{link{linear.functional.terms}}. }

\item{object}{ a fitted \code{gam} object as produced by \code{gam()}.
                }

\item{ci}{Logical indicating whether to include confidence intervals. Defaults
to \code{TRUE}}

\item{type}{ When this has the value \code{"link"} (default) the linear predictor (possibly with
associated standard errors) is returned. When \code{type="terms"} each component of the 
linear predictor is returned seperately (possibly with standard errors): this includes 
parametric model components, followed by each smooth component, but excludes
any offset and any intercept. \code{type="iterms"} is the same, except that any standard errors 
returned for smooth components will include the uncertainty about the intercept/overall mean.  When 
\code{type="response"} predictions 
on the scale of the response are returned (possibly with approximate
standard errors). When \code{type="lpmatrix"} then a matrix is returned
which yields the values of the linear predictor (minus any offset) when
postmultiplied by the
parameter vector (in this case \code{se.fit} is ignored). The latter
option is most useful for getting variance estimates for quantities derived from
the model: for example integrated quantities, or derivatives of smooths. A
linear predictor matrix can also be used to implement approximate prediction
outside \code{R} (see example code, below). }

\item{ci_type}{The method by which standard errors/confidence intervals
will be calculated. Default transforms the linear predictor at
respective intervals. \code{"delta"} calculates CIs based on the standard
error calculated by the Delta method. \code{"sim"} draws the
property of interest from its posterior based on the normal distribution of
the estimated coefficients. CIs are given by respective quantiles.}

\item{time_var}{Name of the variable used for the baseline hazard. If
not given, defaults to \code{"tend"} for \code{\link[mgcv]{gam}} fits, else
\code{"interval"}. The latter is assumed to be a factor, the former
numeric.}

\item{se_mult}{Factor by which standard errors are multiplied for calculating
the confidence intervals.}

\item{...}{Further arguments passed to \code{\link[mgcv]{predict.gam}} and
\code{\link{get_hazard}}}
}
\description{
Calculate predicted hazard
}
\keyword{internal}
