% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_functions.R
\name{add_term}
\alias{add_term}
\title{Add the contribution of a term to the linear predictor to data set}
\usage{
add_term(newdata, object, term, se.fit = TRUE, type = "terms",
  se_mult = 2, relative = FALSE, ...)
}
\arguments{
\item{newdata}{ A data frame or list containing the values of the model covariates at which predictions
  are required. If this is not provided then predictions corresponding to the
                original data are returned. If \code{newdata} is provided then
                it should contain all the variables needed for prediction: a
                warning is generated if not. See details for use with \code{link{linear.functional.terms}}. }

\item{object}{ a fitted \code{gam} object as produced by \code{gam()}.
                }

\item{term}{A character (vector) or regular expression indicating for
which term(s) information should be extracted and added to data set.}

\item{se.fit}{ when this is TRUE (not default) standard error estimates are returned for each prediction.}

\item{type}{ When this has the value \code{"link"} (default) the linear predictor (possibly with
associated standard errors) is returned. When \code{type="terms"} each component of the 
linear predictor is returned seperately (possibly with standard errors): this includes 
parametric model components, followed by each smooth component, but excludes
any offset and any intercept. \code{type="iterms"} is the same, except that any standard errors 
returned for smooth components will include the uncertainty about the intercept/overall mean.  When 
\code{type="response"} predictions 
on the scale of the response are returned (possibly with approximate
standard errors). When \code{type="lpmatrix"} then a matrix is returned
which yields the values of the linear predictor (minus any offset) when
postmultiplied by the
parameter vector (in this case \code{se.fit} is ignored). The latter
option is most useful for getting variance estimates for quantities derived from
the model: for example integrated quantities, or derivatives of smooths. A
linear predictor matrix can also be used to implement approximate prediction
outside \code{R} (see example code, below). }

\item{se_mult}{The factor by which standard errors are multiplied to form
confidence intervals.}

\item{relative}{If \code{TRUE}, calculates relative risk contribution,
that is \eqn{(X-\bar{X})'\beta} and respective confidence intervals
if \code{se.fit = TRUE}. Defaults to \code{FALSE}.}

\item{...}{Further arguments passed to \code{\link[mgcv]{predict.gam}}}
}
\description{
Adds the contribution of a specific term to the
linear predictor to the data specified by \code{newdata}.
Essentially a wrapper to \code{\link[mgcv]{predict.gam}}, with \code{type="terms"}.
Thus most arguments and their documentation below is from \code{\link[mgcv]{predict.gam}}.
}
\examples{
ped <- tumor[1:50,] \%>\% as_ped(Surv(days, status)~ age)
pam <- mgcv::gam(ped_status ~ s(tend)+age, data = ped, family=poisson(), offset=offset)
ped_info(ped) \%>\% add_term(pam, term="tend")
}
