% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.fev.R
\name{read.fev}
\alias{read.fev}
\title{Reads a .fev file created by 'palmscan'}
\usage{
read.fev(fev.path, FIRST = FALSE)
}
\arguments{
\item{fev.path}{relative system path to .fev file}

\item{FIRST}{read only the first palmscan-line in .fev [FALSE]}
}
\value{
A palmscan data.frame object
}
\description{
Reads a .fev file created by 'palmscan'
}
\examples{

# palmscan fev file
ps.fev.path <- system.file( "extdata", "waxsys.fev", package = "palmid")
palmprint <- read.fev(ps.fev.path, FIRST = TRUE)

}
\keyword{fev}
\keyword{palmid}
