% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotTaxHist.R
\name{PlotTaxHist}
\alias{PlotTaxHist}
\title{Plot Percent-identity, factored on taxonomic strings of a pro df}
\usage{
PlotTaxHist(pro.pident, pro.tax, rank = NA)
}
\arguments{
\item{pro.pident}{numeric, pident column from pro.df}

\item{pro.tax}{character, tax column from pro.df (use: get.tax)}

\item{rank}{character, string of tax-rank to label graph}
}
\value{
A histogram as a ggplot2 object
}
\description{
Plot Percent-identity, factored on taxonomic strings of a pro df
}
\examples{

data("waxsys.pro.df")

taxHist <- PlotTaxHist(pro.pident = waxsys.pro.df$pident,
                       pro.tax    = waxsys.pro.df$tfam,
                       rank       = "family")

}
\keyword{palmid}
\keyword{plot}
\keyword{pro}
\keyword{taxonomy}
