% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_scales_binned.R
\name{ggplot2-scales-binned}
\alias{ggplot2-scales-binned}
\alias{scale_colour_paletteer_binned}
\alias{scale_color_paletteer_binned}
\alias{scale_fill_paletteer_binned}
\title{Binned scales to use for ggplot2}
\usage{
scale_colour_paletteer_binned(palette, direction = 1, ...)

scale_color_paletteer_binned(palette, direction = 1, ...)

scale_fill_paletteer_binned(palette, direction = 1, ...)
}
\arguments{
\item{palette}{Name of palette as a string. Must be on the form
packagename::palettename.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{...}{Arguments to pass on to \code{ggplot2::scale_colour_stepsn()} or
\code{ggplot2::scale_fill_stepsn()}}
}
\value{
A \code{ScaleContinuous} object that can be added to a \code{ggplot} object
}
\description{
These functions provide the option to use binned palettes along with the
\code{ggplot2} package. It goes without saying that it requires \code{ggplot2} to work.
}
\details{
Available package/palette combinations are available in the data.frame
\code{\link[paletteer]{palettes_c_names}}.
}
\examples{
\dontshow{if (rlang::is_installed(c("scico", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width, colour = Petal.Length)) +
  geom_point() +
  scale_colour_paletteer_binned("scico::tokyo")
\dontshow{\}) # examplesIf}
}
