% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{fitGpunc}
\alias{fitGpunc}
\title{Fit trait evolution model with punctuations estimated from the data}
\usage{
fitGpunc(
  y,
  ng = 2,
  minb = 7,
  pool = TRUE,
  oshare = TRUE,
  method = c("Joint", "AD"),
  silent = FALSE,
  hess = FALSE,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{ng}{number of groups (segments) in the sequence}

\item{minb}{minimum number of populations within each segment}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{oshare}{logical, if TRUE, variance assumed to be shared (equal) across segments}

\item{method}{parameterization to use: \code{Joint} or \code{AD}; see Details}

\item{silent}{logical, if TRUE, progress updates are suppressed}

\item{hess}{if TRUE, standard errors computed from the Hessian matrix are returned}

\item{parallel}{logical, if TRUE, the analysis is done in parallel}

\item{...}{other arguments, passed to optimization functions}
}
\value{
a \code{paleoTSfit} object with the results of the model-fitting.
}
\description{
Fit trait evolution model with punctuations estimated from the data
}
\details{
This function tests all possible shift points for punctuations, subject to the
constraint that the number of populations in each segment is always >= \code{minb}. The
shiftpoint yielding the highest log-likelihood is returned as the solution, along with
the log-likelihoods (\code{all.logl}) of all tested shift points (\code{GG}). \cr \cr

The function uses \code{opt.punc} (if \code{method = "AD"}) or \code{opt.joint.punc}
(if \code{method = "Joint"}) to do the fitting.
}
\note{
Calculations can be sped up by setting \code{parallel = TRUE}, which uses functions from
the \code{\link{doParallel}} package to run the bootstrap replicates in parallel, using
one fewer than the number of detected cores.
}
\examples{
x <- sim.punc(ns = c(15, 15), theta = c(0,3), omega = c(0.1, 0.1))
w.punc <- fitGpunc(x, oshare = TRUE)
plot(x, modelFit = w.punc)
}
\seealso{
\code{\link{fit9models}}, \code{\link{sim.punc}}
}
