% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{fitModeShift}
\alias{fitModeShift}
\title{Fit model in which the mode of trait evolution shifts once}
\usage{
fitModeShift(y, minb = 7, pool = TRUE, order = c("Stasis-RW",
  "RW-Stasis"), rw.model = c("URW", "GRW"), method = c("Joint", "AD"),
  silent = FALSE, hess = FALSE, ...)
}
\arguments{
\item{y}{\code{paleoTS} object}

\item{minb}{minimum number of populations within each segment}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{order}{whether stasis or random walk come first, one of \code{Stasis-RW} or
\code{RW-Stasis}}

\item{rw.model}{whether the random walk segment is an unbiased random walk, \code{URW}
or a general random walk, \code{GRW}}

\item{method}{parameterization to use: \code{Joint} or \code{AD}}

\item{silent}{logical, if TRUE, progress updates are suppressed}

\item{hess}{if TRUE, standard errors computed from the Hessian matrix are returned}

\item{...}{other arguments, passed to optimization functions}
}
\value{
a \code{paleoTSfit} object
}
\description{
Trait evolution is modeled as a shift from a random walk (general or unbiased) to stasis, or
vice versa.
}
\examples{
x <- sim.Stasis.RW(ns = c(15, 15), omega = 0.5, ms = 1, order = "Stasis-RW")
plot(x)
w <- fitModeShift(x, order = "Stasis-RW", rw.model = "GRW")
abline(v = x$tt[15], lwd = 3)  # actual shift point
abline(v = x$tt[w$par["shift1"]], lty = 3, lwd = 2, col = "red") # inferred shift

}
\seealso{
\code{\link{sim.Stasis.RW}}
}
